---
title: Lecture 55：交错级数
tags:
  - 数学
  - 无穷级数
categories: 
date: 2024-02-14
---
---
## 49.1 交错级数
### 49.1.1 交错级数概念
##### **定义**： #交错级数
> <font color="#ccc1d9">描述：</font> $$\sum_{n=1}^\infty(-1)^{n-1}u_n,u_n>0$$

**解释**
+ 正负交错出现的级数：
	+ 1. $u_{1}-u_{2}+u_{3}-u_{4}+u_{5}-u_{6}+\cdots$；
	+ 2. $-u_{1}+u_{2}-u_{3}+u_{4}-u_{5}+u_{6}\cdots$；
	+ 这种级数称之为交错级数；
+ 并且 $u_n >=0$

**注意**
+ 如果项数是无穷项时，**小括号不能随便加**，**顺序也不能随便换**；
+ 比如：
	+ $1-1+1-1+1-1+1-1+1-1+1-1+1......$
	+ 如果是奇数项 -> 结果为 1；
	+ 如果时偶数项 -> 结果为 0；
+ 如果加括号
	+ $(1-1)+(1-1)+(1-1)+(1-1)+......$
	+ 这样对无穷项加括号，可能会有问题，因为不清楚是奇数项还是偶数项；

### 49.1.2 交错级数判断方法
##### **定理**： #莱布尼茨准则
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>当前有交错级数 $\sum_{n=1}^{+\infty}\left(-1\right)^{n-1}u_{n}$，当：
> 1）$u_{n}\geq u_{n+1}$：单调减
> 2）$\lim_{n\to\infty}u_{n}=0$
> 则可得到 $\sum_{n=1}^{+\infty}\left(-1\right)^{n-1}u_{n}$ 级数收敛，`S` `<=` $u_1$，且 $|r_{n}|\leq u_{n+1}$

**解释**
+ 注意：
	+ 要求：
		+ 1）$u_{n}\geq u_{n+1}$：单调减
		+ 2）$\lim_{n\to\infty}u_{n}=0$
	+ 这两个要求是交错级数收敛的**充分条件**，也就是说这两个里面如果有一个不成立，也有可能交错级数收敛；
+ 前提：
	+ 使用莱布尼茨定理之前，需要保证当前是交错级数；
	+ 后一项比前一项越来越小；
	+ 且 $u_n$ 是往 0 逼近的；

**举例**：关于莱布尼茨准则是充分条件
+ $$\sum_{n=1}^\infty\frac{(-1)^{n-1}}{2^{n+(-1)^n}}\text{ 收敛,但 }u_n=\frac1{2^{n+(-1)^n}}\text{ 并不递减}.$$

## 49.2 任意项级数
### 49.2.1 任意项级数概念
**任意项级数概念**
+ 特点： 
	+ 有正项、有负项；
	+ 并且正项、负项都得是无限项；
+ 任意项： $u_{1}+u_{2}+u_{3}+u_{4}+\cdots$，并且 $u_n$ 的正负不知道；
+ 正项级数：$|u_{1}|+|u_{2}|+|u_{3}|+|u_{4}|+\cdots$ ，每项都取绝对值；
	+ 这种为绝对值级数；

### 49.2.2 任意项级数判断方法
**原则**：把新问题化成老问题 `->` 把一个变号的级数，化成一个正项级数 `->` 通项加一个绝对值 `->` 这个新的正项级数收敛时，任意项级数也收敛；

##### **定义**： #绝对收敛与条件收敛
> <font color="#ccc1d9">描述：</font>
> 1. 绝对收敛：如果加了绝对值的 $\sum|u_{n}|$ 收敛，则称 $\sum u_n$ 收敛；
> 2. 条件收敛：如果 $u_n$ 是收敛的，$\sum|u_{n}|$ 是发散的，则称 $\sum u_n$ 是条件收敛的； 
> 具体情况：
> (1) 若 $\sum^{\infty}_{n=1}=|a_n|$ 收敛，则 $\sum^{\infty}_{n=1}=a_n$ 必收敛，此时称 $\sum^{\infty}_{n=1}a_n$ 绝对收敛 
> (2) 若 $\sum^{\infty}_{n=1}=a_n$ 收敛，$\sum^{\infty}_{n=1}=|a_n|$ 发散，则称 $\sum^{\infty}_{n=1}a_n$ 条件收敛

**解释**
+ 绝对收敛    
	+ $\sum|u_{n}|$ 收敛
	+ $\sum u_n$   收敛
+ 条件收敛
	+ $\sum|u_{n}|$ 发散
	+ $\sum u_n$   收敛

**举例**
+ $\sum(-1)^{n-1}\frac{1}{n}$：交错调节级数 -> 收敛的；
+ $\sum(-1)^{n}\frac{1}{n^{3}}$：是绝对收敛的；

**基本结论**
+ 1. 绝对收敛的级数，一定收敛 `->` 即：$\sum^{\infty}_{n=1}|a_n|$ 收敛 `->` $\sum^{\infty}_{n=1}a_n$ 收敛；
+ 2. 条件收敛的级数的所有正项（或负项）构成的级数，一定发散 `->` $$\sum_{n=1}^\infty u_n\text{ 条件收敛 }\Rightarrow\sum_{n=1}^\infty\frac{u_n+|u_n|}2\text{ 和 }\sum_{n=1}^\infty\frac{u_n-|u_n|}2\text{ 发散}.$$

##### **定理**： #任意项级数的绝对收敛
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果每项都加绝对值 $\sum_{n=1}^{+\infty}|u_{n}|$ 以后，它是收敛的，则它原来的级数 $\sum_{n=1}^{+\infty}u_{n}$ 也是收敛的；

**解释**
+ 更简单的理解：
	+ 全是正数（加绝对值）的情况下都可以收敛，那他原本有正有负的情况下就更应该是收敛的；

##### **定理**： #任意项级数发散收敛判断
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果 $\sum_{n=1}^{+\infty}u_{n}=u_{1}+u_{2}+u_{3}+\cdots$ 是任意项级数，且 $\lim_{n\to+\infty}\left|\frac{u_{n+1}}{u_{n}}\right|=l$
> 1）当 $l$ < 1 时，$\sum u_n$ 绝对收敛；
> 2）当 $L>1(+\infty)$ 时，$\sum u_n$ 发散；
> 3）当 L =1 时，无法判断；

**解释**
+ 如果 L>1，则原本的级数就是发散的；
